/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.camera;

import com.hollingsworth.arsnouveau.common.util.ClientCameraUtil;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(modid="ars_nouveau", value={Dist.CLIENT})
public class ClientCameraEvents {
    public static final ResourceLocation[] overlays = new ResourceLocation[]{VanillaGuiLayers.JUMP_METER, VanillaGuiLayers.EXPERIENCE_BAR, VanillaGuiLayers.EFFECTS};

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (ClientCameraUtil.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (ClientCameraUtil.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
            event.setSwingHand(false);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onGuiOpen(RenderGuiLayerEvent.Pre event) {
        if (ClientCameraUtil.isPlayerMountedOnCamera()) {
            for (ResourceLocation overlay : overlays) {
                if (!event.getName().equals((Object)overlay)) continue;
                event.setCanceled(true);
            }
        }
    }
}

